function [A,B] = solution_getmatrices_x(GLOBALS,THETA,xss,yss,sss,~)

% -- Other Setup -- %
% E = exp(1);
ny = GLOBALS.ny;
nx = GLOBALS.nx;
n = nx + ny;
ns = GLOBALS.ns;
A = cell(ns,ns);
B = cell(ns,ns);


% -- Load Calibrated Parameters -- %
bbeta           = GLOBALS.parameters.bbeta;
rrho            = GLOBALS.parameters.rrho;
aalpha          = GLOBALS.parameters.aalpha;
eeta            = GLOBALS.parameters.eeta;
ddelta          = GLOBALS.parameters.ddelta;
oomega          = GLOBALS.parameters.oomega;
ebar            = GLOBALS.parameters.ebar;
pbar            = GLOBALS.parameters.pbar;
abar            = GLOBALS.parameters.abar;
zbar            = GLOBALS.parameters.zbar;
varphi(1)       = GLOBALS.parameters.varphi0;
varphi(2)       = GLOBALS.parameters.varphi0;
varphi(3)       = GLOBALS.parameters.varphi1;
varphi(4)       = GLOBALS.parameters.varphi1;
nnu(1)          = GLOBALS.parameters.nnu0;
nnu(2)          = GLOBALS.parameters.nnu0;
nnu(3)          = GLOBALS.parameters.nnu1;
nnu(4)          = GLOBALS.parameters.nnu1;

% -- Load Estimated Parameters -- %
iiota           = THETA(GLOBALS.parm_ind.iiota);
pphi            = THETA(GLOBALS.parm_ind.pphi);
rbar            = THETA(GLOBALS.parm_ind.rbar);
rrhoa           = THETA(GLOBALS.parm_ind.rrhoa);
rrhoz           = THETA(GLOBALS.parm_ind.rrhoz);
rrhop           = THETA(GLOBALS.parm_ind.rrhop);
rrhor           = THETA(GLOBALS.parm_ind.rrhor);
rrhoe           = THETA(GLOBALS.parm_ind.rrhoe);
rrhod           = THETA(GLOBALS.parm_ind.rrhod);
ssigmaa_l       = THETA(GLOBALS.parm_ind.ssigmaa_l);
ssigmaa_h       = THETA(GLOBALS.parm_ind.ssigmaa_h);
ssigmaz_l       = THETA(GLOBALS.parm_ind.ssigmaz_l);
ssigmaz_h       = THETA(GLOBALS.parm_ind.ssigmaz_h);
ssigmap_l       = THETA(GLOBALS.parm_ind.ssigmap_l);
ssigmap_h       = THETA(GLOBALS.parm_ind.ssigmap_h);
ssigmar_l       = THETA(GLOBALS.parm_ind.ssigmar_l);
ssigmar_h       = THETA(GLOBALS.parm_ind.ssigmar_h);
ssigmae_l       = THETA(GLOBALS.parm_ind.ssigmae_l);
ssigmae_h       = THETA(GLOBALS.parm_ind.ssigmae_h);
ssigmad_l       = THETA(GLOBALS.parm_ind.ssigmad_l);
ssigmad_h       = THETA(GLOBALS.parm_ind.ssigmad_h);
psigma_ll       = THETA(GLOBALS.parm_ind.psigma_ll);
psigma_hh       = THETA(GLOBALS.parm_ind.psigma_hh);

% Load Estimated or Calibrated Parameters -- %
try
    kkappa          = THETA(GLOBALS.parm_ind.kkappa);
    ppsir           = GLOBALS.parameters.ppsir;
    bbar            = GLOBALS.parameters.bbar;
catch
    kkappa          = GLOBALS.parameters.kkappa;
    ppsir           = THETA(GLOBALS.parm_ind.ppsir);
    bbar            = THETA(GLOBALS.parm_ind.bbar);
end
try
    ggamma00        = log(GLOBALS.parameters.p01/(1-GLOBALS.parameters.p01));
    ggamma10        = log(GLOBALS.parameters.p10/(1-GLOBALS.parameters.p10));
catch
    ggamma00        = log(THETA(GLOBALS.parm_ind.p01)/(1-THETA(GLOBALS.parm_ind.p01)));
    ggamma10        = log(THETA(GLOBALS.parm_ind.p10)/(1-THETA(GLOBALS.parm_ind.p10)));
end

try
    ggamma01        = exp(THETA(GLOBALS.parm_ind.loggamma01));
    ggamma11        = exp(THETA(GLOBALS.parm_ind.loggamma11));
catch
    ggamma01        = exp(GLOBALS.parameters.loggamma01);
    ggamma11        = exp(GLOBALS.parameters.loggamma11);
end

% -- Perturbation Point -- %
varphibar   = varphi*sss;


param = [bbeta, rrho, oomega, eeta, aalpha, ddelta, pbar, ebar, iiota, pphi, rbar, kkappa, rrhoa, rrhoz, rrhop, rrhor, rrhoe, rrhod, varphibar, bbar, ppsir, abar, zbar];


for s = 1:ns
    for sp = 1:ns
        [A{sp,s},B{sp,s}] = mex_getmatrices_x(n,xss,yss,param,nnu(s));
    end
end
